///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Precompiled Header
#include "Stdafx.h"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/**
 *	Shape export method.
 *	This method is called once for each exported shape.
 *	\param		shape		[in] a structure filled with current shape information.
 *	\return		true if success.
 */
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
bool ZCBFormat::ExportShape(const ShapeDescriptor& shape)
{
	// Export common information
	ExportBasicInfo(&shape, &mShapes);

	// Export shape parameters

	// Number of lines
	mShapes.Store(shape.mNbLines).Store(shape.mMatID);

	// Export all lines
	udword p=0;
	for(udword i=0;i<shape.mNbLines;i++)
	{
		udword NbVerts = shape.mNbVerts[i];
		bool Closed = shape.mClosed[i];
		mShapes.Store(NbVerts).Store(Closed);
		for(udword j=0;j<NbVerts;j++)
		{
			mShapes.Store(shape.mVerts[p].x).Store(shape.mVerts[p].y).Store(shape.mVerts[p].z);
			p++;
		}
	}

	return true;
}
